<?php

class CQtrMimetype
{
    private $mimes;
    
    public function __construct()
    {
        $this->mimes = array (
            array("binary", "MZ", 0, ".exe"),
            array("binary", "\x7f\x45\x4c\x46", 0, ".elf"),
            array("document", "\x25\x50\x44\x46", 0, ".pdf"),
            array("compress", "\x50\x4b", 0, ".zip"),
            array("compress", "\x42\x5a", 0, ".bz"),
            array("compress", "\x1f\x8b", 0, ".gz"),
            array("compress", "\x52\x61\x72\x21\x1a\x07\x01", 0, ".rar"),
            array("image", "\x89\x50\x4e\x47", 0, ".png"),
            array("image", "GIF", 0, ".gif"),
            array("image", "VIEW", 0, ".pm"),
            array("image", "\xff\xd8\xff\xe0", 0, ".jpg"),
            array("image", "\x4d\x4d\x00\x2a", 0, ".tif"),
            array("image", "\x49\x49\x2a\x00", 0, ".tif"),
            array("image", "BM", 0, ".bmp"),
            array("video", "\x14\x66\x74\x79\x70", 3, ".mp4"),
            array("video", "\x46\x4c\x56\x01", 0, ".flv"),
            array("audio", "\x49\x44\x33", 0, ".mp3"),
            array("helpfile", "\x49\x6e\x6e\x6f\x20\x53\x65\x74\x75\x70\x20\x55\x6e\x69\x6e\x73\x74\x61\x6c\x6c\x20\x4c\x6f\x67", 0, ".chm")
        );
    }

    public function CheckMimeType( $filename )
    {
        foreach($this->mimes as $mime)
        {
            $pos = strpos($this->getHeader($filename), $mime[1]);
            if ($pos === FALSE)
            {
                continue;
            }
            else if ($pos == $mime[2])
            {
                return $mime[0];
            }
        }
        return "textfile";
    }

    private function getHeader( $filename )
    {
    	$handle = fopen($filename, "rb");
        $contents = fread($handle, 100);
        fclose($handle);
        return $contents;
    }
}

?>
