<?php
define('THEME_VERSION', '1.0.1');

//Since WP v4.7 using new functions
//https://developer.wordpress.org/themes/basics/linking-theme-files-directories/#linking-to-theme-directories
define( 'DOTDIGITAL_THEME_URI', get_parent_theme_file_uri() );
define( 'DOTDIGITAL_THEME_PATH', get_parent_theme_file_path() );

/**
 * Theme Includes
 *
 * https://github.com/ThemeFuse/Theme-Includes
 */
require_once DOTDIGITAL_THEME_PATH . '/inc/init.php';

/**
 * TGM Plugin Activation
 */
if ( ! class_exists( 'TGM_Plugin_Activation' ) ) {
	/**
	 * Include the TGM_Plugin_Activation class.
	 */
	require_once DOTDIGITAL_THEME_PATH . '/inc/tgm-plugin-activation/class-tgm-plugin-activation.php';
}

add_action( 'tgmpa_register', 'dotdigital_action_register_required_plugins' );


if ( ! function_exists( 'dotdigital_action_register_required_plugins' ) ):
	/** @internal */
	function dotdigital_action_register_required_plugins() {
		$plugins = array (
			array (
				'name'             => 'Unyson',
				'slug'             => 'unyson',
				'required'         => true,
			),
			array (
				'name'             => 'MWTemplates Theme Addons',
				'slug'             => 'mwt-addons',
				'source'           => DOTDIGITAL_THEME_PATH . '/inc/plugins/mwt-addons.zip',
				'required'         => true,
				'version'          => '1.0',
			),
			array (
				'name'             => 'MWTemplates Developer',
				'slug'             => 'mwt-developer',
				'source'           => DOTDIGITAL_THEME_PATH . '/inc/plugins/mwt-developer.zip',
				'required'         => false,
			),
			array (
				'name'             => 'Woocommerce',
				'slug'             => 'woocommerce',
				'required'         => true,
			),
			array (
				'name'      => 'MWT Unyson Extension',
				'slug'      => 'mwt-unyson-extensions',
				'source'    => DOTDIGITAL_THEME_PATH . '/inc/plugins/mwt-unyson-extensions.zip',
				'required'  => false,
			),
			array (
				'name'      => 'Booked plugin',
				'slug'      => 'booked',
				'source'    => DOTDIGITAL_THEME_PATH . '/inc/plugins/booked.zip',
				'required'  => false,
			),
			array (
				'name'      => 'Envato Market',
				'slug'      => 'envato-market',
				'source'    => esc_url('https://envato.github.io/wp-envato-market/dist/envato-market.zip'),
				'required'  => true,
			),
			array (
				'name'             => 'MWT Maintenance Mode',
				'slug'             => 'mwt-maintenance',
				'source'           => DOTDIGITAL_THEME_PATH . '/inc/plugins/mwt-maintenance.zip',
			    'required'         => false,
			),
			array(
				'name'     				=> 'Instagram Feed',
				'slug'     				=> 'instagram-feed',
				'required'              => false,
			),
			array(
				'name'     				=> 'User custom avatar',
				'slug'     				=> 'wp-user-avatar',
				'required'              => false,
			),
			array(
				'name'     				=> 'AccessPress Social Counter',
				'slug'     				=> 'accesspress-social-counter',
				'required'              => true
			),
			array(
				'name'     				=> 'Snazzy Maps',
				'slug'     				=> 'snazzy-maps',
				'required'              => true,
			),
			array(
				'name'     				=> 'Widget CSS Classes',
				'slug'     				=> 'widget-css-classes',
				'required'              => false,
			),
		);
		$config = array(
			'domain'       => 'dotdigital',
			'dismissable'  => true,
			'is_automatic' => false
		);
		tgmpa( $plugins, $config );
	}
endif;