<?php if ( ! defined( 'FW' ) ) {
	die( 'Forbidden' );
}

class FW_Shortcode_Team_Slider extends FW_Shortcode {
	protected function _render( $atts, $content = null, $tag = '' ) {

		//get post type dynamically
		$ext_team_settings = fw()->extensions->get( 'team' )->get_settings();
		$post_type = $ext_team_settings['post_type'];
		$taxonomy_name = $ext_team_settings['taxonomy_name'];
		$terms = $atts['cat'];
		$tax_query = false;
		//if some terms are selected in options - creating tax_query
		if ( ! empty( $terms ) ) {
			$tax_query = array(
				array(
					'taxonomy' => $taxonomy_name,
					'terms' => $atts['cat'],
				),
			);
		}
		$posts = $this->fw_get_posts_with_info( array(
			'post_type'   => $post_type,
			'sort'  => 'post_date',
			'items' => $atts['number'],
			'tax_query' => $tax_query,

		) );

		$view_path = $this->locate_path( '/views/view.php' );

		return fw_render_view( $view_path, array(
				'atts'  => $atts,
				'posts' => $posts
			)
		);

	}

	/**
	 * @param array $args
	 *
	 * @return 'WP_Query'
	 */
	public function fw_get_posts_with_info( $args = array() ) {
		$defaults = array(
			'sort'        => 'recent',
			'items'       => 5,
			'image_post'  => true,
			'date_post'   => true,
			'date_format' => 'F jS, Y',
			'post_type'   => 'post',
			'cat'         => false,
		);

		$query = new WP_Query( wp_parse_args( $args, $defaults ) );

		//removed wp reset query

		return $query;
	}

	private function get_error_msg() {
		return '<p>' . esc_html__( 'No view found', 'fw' ) . '</p>';
	}
}