<?php if ( ! defined( 'FW' ) ) {
	die( 'Forbidden' );
}

$options = array(
	'slide_background' => array(
		'type'        => 'select',
		'value'       => 'ls',
		'label'       => esc_html__( 'Slide background', 'dotdigital' ),
		'desc'        => esc_html__( 'Select slide background color', 'dotdigital' ),
		'choices'     => array(
			'ls'    => esc_html__( 'Light', 'dotdigital' ),
			'ds'    => esc_html__( 'Dark', 'dotdigital' ),
			'color_1'    => esc_html__( 'Main color', 'dotdigital' ),
		),
		/**
		 * Allow save not existing choices
		 * Useful when you use the select to populate it dynamically from js
		 */
		'no-validate' => false,
	),
	'slide_align'      => array(
		'type'        => 'select',
		'value'       => 'text-left',
		'label'       => esc_html__( 'Slide text alignment', 'dotdigital' ),
		'desc'        => esc_html__( 'Select slide text alignment', 'dotdigital' ),
		'choices'     => array(
			'text-left'   => esc_html__( 'Left', 'dotdigital' ),
			'text-center' => esc_html__( 'Center', 'dotdigital' ),
			'text-right'  => esc_html__( 'Right', 'dotdigital' ),
		),
		/**
		 * Allow save not existing choices
		 * Useful when you use the select to populate it dynamically from js
		 */
		'no-validate' => false,
	),
	'slide_layers'     => array(
		'type'        => 'addable-box',
		'value'       => '',
		'label'       => esc_html__( 'Slide Layers', 'dotdigital' ),
		'desc'        => esc_html__( 'Choose a tag and text inside it', 'dotdigital' ),
		'box-options' => array(
			'layer_tag'            => array(
				'type'    => 'select',
				'value'   => 'h3',
				'label'   => esc_html__( 'Layer tag', 'dotdigital' ),
				'desc'    => esc_html__( 'Select a tag for your ', 'dotdigital' ),
				'choices' => array(
					'h2' => esc_html__( 'H2 tag', 'dotdigital' ),
					'h3' => esc_html__( 'H3 tag', 'dotdigital' ),
					'h4' => esc_html__( 'H4 tag', 'dotdigital' ),
					'h5' => esc_html__( 'H5 tag', 'dotdigital' ),
					'h6' => esc_html__( 'H6 tag', 'dotdigital' ),
					'p'  => esc_html__( 'P tag', 'dotdigital' ),
					'div'  => esc_html__( 'Div tag', 'dotdigital' ),
				),
			),
			'layer_animation'      => array(
				'type'    => 'select',
				'value'   => 'fadeIn',
				'label'   => esc_html__( 'Animation type', 'dotdigital' ),
				'desc'    => esc_html__( 'Select one of predefined animations', 'dotdigital' ),
				'choices' => array(
					''               => 'Default',
					'slideDown'      => esc_html__( 'slideDown', 'dotdigital' ),
					'scaleAppear'    => esc_html__( 'scaleAppear', 'dotdigital' ),
					'fadeInLeft'     => esc_html__( 'fadeInLeft', 'dotdigital' ),
					'fadeInUp'       => esc_html__( 'fadeInUp', 'dotdigital' ),
					'fadeInRight'    => esc_html__( 'fadeInRight', 'dotdigital' ),
					'fadeInDown'     => esc_html__( 'fadeInDown', 'dotdigital' ),
					'fadeIn'         => esc_html__( 'fadeIn', 'dotdigital' ),
					'slideRight'     => esc_html__( 'slideRight', 'dotdigital' ),
					'slideUp'        => esc_html__( 'slideUp', 'dotdigital' ),
					'slideLeft'      => esc_html__( 'slideLeft', 'dotdigital' ),
					'expandUp'       => esc_html__( 'expandUp', 'dotdigital' ),
					'slideExpandUp'  => esc_html__( 'slideExpandUp', 'dotdigital' ),
					'expandOpen'     => esc_html__( 'expandOpen', 'dotdigital' ),
					'bigEntrance'    => esc_html__( 'bigEntrance', 'dotdigital' ),
					'hatch'          => esc_html__( 'hatch', 'dotdigital' ),
					'tossing'        => esc_html__( 'tossing', 'dotdigital' ),
					'pulse'          => esc_html__( 'pulse', 'dotdigital' ),
					'floating'       => esc_html__( 'floating', 'dotdigital' ),
					'bounce'         => esc_html__( 'bounce', 'dotdigital' ),
					'pullUp'         => esc_html__( 'pullUp', 'dotdigital' ),
					'pullDown'       => esc_html__( 'pullDown', 'dotdigital' ),
					'stretchLeft'    => esc_html__( 'stretchLeft', 'dotdigital' ),
					'stretchRight'   => esc_html__( 'stretchRight', 'dotdigital' ),
					'fadeInUpBig'    => esc_html__( 'fadeInUpBig', 'dotdigital' ),
					'fadeInDownBig'  => esc_html__( 'fadeInDownBig', 'dotdigital' ),
					'fadeInLeftBig'  => esc_html__( 'fadeInLeftBig', 'dotdigital' ),
					'fadeInRightBig' => esc_html__( 'fadeInRightBig', 'dotdigital' ),
					'slideInDown'    => esc_html__( 'slideInDown', 'dotdigital' ),
					'slideInLeft'    => esc_html__( 'slideInLeft', 'dotdigital' ),
					'slideInRight'   => esc_html__( 'slideInRight', 'dotdigital' ),
					'moveFromLeft'   => esc_html__( 'moveFromLeft', 'dotdigital' ),
					'moveFromRight'  => esc_html__( 'moveFromRight', 'dotdigital' ),
					'moveFromBottom' => esc_html__( 'moveFromBottom', 'dotdigital' ),
				),
			),
			'layer_text'           => array(
				'type'  => 'text',
				'value' => '',
				'label' => esc_html__( 'Layer text', 'dotdigital' ),
				'desc'  => esc_html__( 'Text to appear in slide layer', 'dotdigital' ),
			),
			'layer_text_color'     => array(
				'type'    => 'select',
				'value'   => '',
				'label'   => esc_html__( 'Layer text color', 'dotdigital' ),
				'desc'    => esc_html__( 'Select a color for your text in layer', 'dotdigital' ),
				'choices' => array(
					''           => 'Inherited',
					'highlight'  => esc_html__( 'Main color', 'dotdigital' ),
					'highlight2'  => esc_html__( 'Main color 2', 'dotdigital' ),
					'grey'       => esc_html__( 'Grey color', 'dotdigital' ),
					'black'      => esc_html__( 'Dark color', 'dotdigital' ),
					'light'      => esc_html__( 'Light color', 'dotdigital' ),
				),
			),
			'layer_text_weight'    => array(
				'type'    => 'select',
				'value'   => 'regular',
				'label'   => esc_html__( 'Layer text weight', 'dotdigital' ),
				'desc'    => esc_html__( 'Select a weight for your text in layer', 'dotdigital' ),
				'choices' => array(
					'thin-weight'     => esc_html__( 'Thin', 'dotdigital' ),
					'extra-light'     => esc_html__( 'Extra Light', 'dotdigital' ),
					'light-weight'     => esc_html__( 'Light', 'dotdigital' ),
					'regular'     => esc_html__( 'Normal', 'dotdigital' ),
					'medium' => esc_html__( 'Medium', 'dotdigital' ),
					'semibold' => esc_html__( 'Semi Bold', 'dotdigital' ),
					'bold' => esc_html__( 'Bold', 'dotdigital' ),
					'black-weight' => esc_html__( 'Black Weight', 'dotdigital' ),
				),
			),
			'layer_text_transform' => array(
				'type'    => 'select',
				'value'   => 'text-transform-none',
				'label'   => esc_html__( 'Layer text transform', 'dotdigital' ),
				'desc'    => esc_html__( 'Select a text transformation for your layer', 'dotdigital' ),
				'choices' => array(
					'text-transform-none'                => 'None',
					'text-lowercase'  => esc_html__( 'Lowercase', 'dotdigital' ),
					'text-uppercase'  => esc_html__( 'Uppercase', 'dotdigital' ),
					'text-capitalize' => esc_html__( 'Capitalize', 'dotdigital' ),

				),
			),
			'custom_class' => array(
				'type'  => 'text',
				'value' => '',
				'label' => esc_html__( 'Layer custom class', 'dotdigital' ),
				'desc'  => esc_html__( 'Set layer custom class', 'dotdigital' ),
			),
		),
		'template'    => esc_html__( 'Slider Layer', 'dotdigital' ),

		'limit'           => 5, // limit the number of boxes that can be added
		'add-button-text' => esc_html__( 'Add', 'dotdigital' ),
//		'sortable' => true,
	),
	'slide_button'     => array(
		'type'        => 'select',
		'value'       => '',
		'label'       => esc_html__( 'Slide button 1', 'dotdigital' ),
		'desc'        => esc_html__( 'Select slide button. Leave empty if no button needed', 'dotdigital' ),
		'choices'     => array(
			''                     => esc_html__( 'None', 'dotdigital' ),
			'theme_button color1'  => esc_html__( 'Main color 1', 'dotdigital' ),
			'theme_button color2'  => esc_html__( 'Main color 2', 'dotdigital' ),
			'theme_button color3'  => esc_html__( 'Main color 3', 'dotdigital' ),
			'theme_button color4'  => esc_html__( 'Main color 4', 'dotdigital' ),
			'theme_button inverse color1'  => esc_html__( 'Main color 1 inverse', 'dotdigital' ),
			'theme_button inverse color2'  => esc_html__( 'Main color 2 inverse', 'dotdigital' ),
			'theme_button inverse color3'  => esc_html__( 'Main color 3 inverse', 'dotdigital' ),
			'theme_button inverse color4'  => esc_html__( 'Main color 4 inverse', 'dotdigital' ),
		),
		/**
		 * Allow save not existing choices
		 * Useful when you use the select to populate it dynamically from js
		 */
		'no-validate' => false,
	),

	'slide_button_text'      => array(
		'type'  => 'text',
		'value' => '',
		'label' => esc_html__( 'Slide button 1 text', 'dotdigital' ),
		'desc'  => esc_html__( 'Text in button', 'dotdigital' ),
	),
	'slide_button_link'      => array(
		'type'  => 'text',
		'value' => '',
		'label' => esc_html__( 'Slide button 1 link', 'dotdigital' ),
		'desc'  => esc_html__( 'Paste a link', 'dotdigital' ),
	),
	'slide_button_animation' => array(
		'type'    => 'select',
		'value'   => 'fadeIn',
		'label'   => esc_html__( 'Button animation type', 'dotdigital' ),
		'desc'    => esc_html__( 'Select one of predefined animations', 'dotdigital' ),
		'choices' => array(
			''               => 'Default',
			'slideDown'      => esc_html__( 'slideDown', 'dotdigital' ),
			'scaleAppear'    => esc_html__( 'scaleAppear', 'dotdigital' ),
			'fadeInLeft'     => esc_html__( 'fadeInLeft', 'dotdigital' ),
			'fadeInUp'       => esc_html__( 'fadeInUp', 'dotdigital' ),
			'fadeInRight'    => esc_html__( 'fadeInRight', 'dotdigital' ),
			'fadeInDown'     => esc_html__( 'fadeInDown', 'dotdigital' ),
			'fadeIn'         => esc_html__( 'fadeIn', 'dotdigital' ),
			'slideRight'     => esc_html__( 'slideRight', 'dotdigital' ),
			'slideUp'        => esc_html__( 'slideUp', 'dotdigital' ),
			'slideLeft'      => esc_html__( 'slideLeft', 'dotdigital' ),
			'expandUp'       => esc_html__( 'expandUp', 'dotdigital' ),
			'slideExpandUp'  => esc_html__( 'slideExpandUp', 'dotdigital' ),
			'expandOpen'     => esc_html__( 'expandOpen', 'dotdigital' ),
			'bigEntrance'    => esc_html__( 'bigEntrance', 'dotdigital' ),
			'hatch'          => esc_html__( 'hatch', 'dotdigital' ),
			'tossing'        => esc_html__( 'tossing', 'dotdigital' ),
			'pulse'          => esc_html__( 'pulse', 'dotdigital' ),
			'floating'       => esc_html__( 'floating', 'dotdigital' ),
			'bounce'         => esc_html__( 'bounce', 'dotdigital' ),
			'pullUp'         => esc_html__( 'pullUp', 'dotdigital' ),
			'pullDown'       => esc_html__( 'pullDown', 'dotdigital' ),
			'stretchLeft'    => esc_html__( 'stretchLeft', 'dotdigital' ),
			'stretchRight'   => esc_html__( 'stretchRight', 'dotdigital' ),
			'fadeInUpBig'    => esc_html__( 'fadeInUpBig', 'dotdigital' ),
			'fadeInDownBig'  => esc_html__( 'fadeInDownBig', 'dotdigital' ),
			'fadeInLeftBig'  => esc_html__( 'fadeInLeftBig', 'dotdigital' ),
			'fadeInRightBig' => esc_html__( 'fadeInRightBig', 'dotdigital' ),
			'slideInDown'    => esc_html__( 'slideInDown', 'dotdigital' ),
			'slideInLeft'    => esc_html__( 'slideInLeft', 'dotdigital' ),
			'slideInRight'   => esc_html__( 'slideInRight', 'dotdigital' ),
			'moveFromLeft'   => esc_html__( 'moveFromLeft', 'dotdigital' ),
			'moveFromRight'  => esc_html__( 'moveFromRight', 'dotdigital' ),
			'moveFromBottom' => esc_html__( 'moveFromBottom', 'dotdigital' ),
		),
	),
	'slide_button_2'     => array(
		'type'        => 'select',
		'value'       => '',
		'label'       => esc_html__( 'Slide button 2', 'dotdigital' ),
		'desc'        => esc_html__( 'Select slide button. Leave empty if no button needed', 'dotdigital' ),
		'choices'     => array(
			''                     => esc_html__( 'None', 'dotdigital' ),
			'theme_button color1'  => esc_html__( 'Main color 1', 'dotdigital' ),
			'theme_button color2'  => esc_html__( 'Main color 2', 'dotdigital' ),
			'theme_button color3'  => esc_html__( 'Main color 3', 'dotdigital' ),
			'theme_button color4'  => esc_html__( 'Main color 4', 'dotdigital' ),
			'theme_button inverse color1'  => esc_html__( 'Main color 1 inverse', 'dotdigital' ),
			'theme_button inverse color2'  => esc_html__( 'Main color 2 inverse', 'dotdigital' ),
			'theme_button inverse color3'  => esc_html__( 'Main color 3 inverse', 'dotdigital' ),
			'theme_button inverse color4'  => esc_html__( 'Main color 4 inverse', 'dotdigital' ),
		),
		/**
		 * Allow save not existing choices
		 * Useful when you use the select to populate it dynamically from js
		 */
		'no-validate' => false,
	),

	'slide_button_2_text'      => array(
		'type'  => 'text',
		'value' => '',
		'label' => esc_html__( 'Slide button 2 text', 'dotdigital' ),
		'desc'  => esc_html__( 'Text in button', 'dotdigital' ),
	),
	'slide_button_2_link'      => array(
		'type'  => 'text',
		'value' => '',
		'label' => esc_html__( 'Slide button 2 link', 'dotdigital' ),
		'desc'  => esc_html__( 'Paste a link', 'dotdigital' ),
	),
	'slide_button_2_animation' => array(
		'type'    => 'select',
		'value'   => 'fadeIn',
		'label'   => esc_html__( 'Button animation type', 'dotdigital' ),
		'desc'    => esc_html__( 'Select one of predefined animations', 'dotdigital' ),
		'choices' => array(
			''               => 'Default',
			'slideDown'      => esc_html__( 'slideDown', 'dotdigital' ),
			'scaleAppear'    => esc_html__( 'scaleAppear', 'dotdigital' ),
			'fadeInLeft'     => esc_html__( 'fadeInLeft', 'dotdigital' ),
			'fadeInUp'       => esc_html__( 'fadeInUp', 'dotdigital' ),
			'fadeInRight'    => esc_html__( 'fadeInRight', 'dotdigital' ),
			'fadeInDown'     => esc_html__( 'fadeInDown', 'dotdigital' ),
			'fadeIn'         => esc_html__( 'fadeIn', 'dotdigital' ),
			'slideRight'     => esc_html__( 'slideRight', 'dotdigital' ),
			'slideUp'        => esc_html__( 'slideUp', 'dotdigital' ),
			'slideLeft'      => esc_html__( 'slideLeft', 'dotdigital' ),
			'expandUp'       => esc_html__( 'expandUp', 'dotdigital' ),
			'slideExpandUp'  => esc_html__( 'slideExpandUp', 'dotdigital' ),
			'expandOpen'     => esc_html__( 'expandOpen', 'dotdigital' ),
			'bigEntrance'    => esc_html__( 'bigEntrance', 'dotdigital' ),
			'hatch'          => esc_html__( 'hatch', 'dotdigital' ),
			'tossing'        => esc_html__( 'tossing', 'dotdigital' ),
			'pulse'          => esc_html__( 'pulse', 'dotdigital' ),
			'floating'       => esc_html__( 'floating', 'dotdigital' ),
			'bounce'         => esc_html__( 'bounce', 'dotdigital' ),
			'pullUp'         => esc_html__( 'pullUp', 'dotdigital' ),
			'pullDown'       => esc_html__( 'pullDown', 'dotdigital' ),
			'stretchLeft'    => esc_html__( 'stretchLeft', 'dotdigital' ),
			'stretchRight'   => esc_html__( 'stretchRight', 'dotdigital' ),
			'fadeInUpBig'    => esc_html__( 'fadeInUpBig', 'dotdigital' ),
			'fadeInDownBig'  => esc_html__( 'fadeInDownBig', 'dotdigital' ),
			'fadeInLeftBig'  => esc_html__( 'fadeInLeftBig', 'dotdigital' ),
			'fadeInRightBig' => esc_html__( 'fadeInRightBig', 'dotdigital' ),
			'slideInDown'    => esc_html__( 'slideInDown', 'dotdigital' ),
			'slideInLeft'    => esc_html__( 'slideInLeft', 'dotdigital' ),
			'slideInRight'   => esc_html__( 'slideInRight', 'dotdigital' ),
			'moveFromLeft'   => esc_html__( 'moveFromLeft', 'dotdigital' ),
			'moveFromRight'  => esc_html__( 'moveFromRight', 'dotdigital' ),
			'moveFromBottom' => esc_html__( 'moveFromBottom', 'dotdigital' ),
		),
	),
);