<?php if ( ! defined( 'FW' ) ) {
	die( 'Forbidden' );
}
/**
 * @var $atts
 */

if ( ! $atts['steps'] ) {
	return;
}
?>
<div class="fw-theme-steps">
	<?php foreach ( $atts['steps'] as $step ) : ?>
        <div class="fw-theme-step-wrap">
            <div class="fw-step-left-part">
                <?php if ( ! empty( $step['step_title'] ) ): ?>
                    <h2 class="step-title <?php echo esc_attr( $step['number_color'] ); ?>"><?php echo wp_kses_post( $step['step_title'] ); ?></h2>
                <?php endif; ?>
            </div>
            <div class="fw-step-center-part">
                <img src="<?php echo esc_url( $step['step_image']['url'] ); ?>"
                     alt="<?php echo esc_attr( $step['step_title'] ); ?>">
            </div>
            <div class="fw-step-right-part">
                <?php if ( ! empty( $step['step_text'] ) ): ?>
                    <p class="step-text"><?php echo wp_kses_post( $step['step_text'] ); ?></p>
                <?php endif; ?>
            </div>
        </div>
	<?php endforeach; ?>
</div>