<?php
/**
 * Maintenance mode template that's shown to logged out users.
 *
 * @package   mwt-maintenance
 * @copyright Copyright (c) 2017, MWTemplates
 * @license   GPLv2 or later
 */
?>
<!DOCTYPE html>
<html>
<head>
    <meta charset="UTF-8">
    <meta charset="<?php bloginfo( 'charset' ); ?>">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <link rel="profile" href="http://gmpg.org/xfn/11">
    <link rel="stylesheet" href="<?php echo plugins_url( 'assets/css/maintenance.css', dirname( __FILE__ ) ); ?>">

    <title>Under Maintenance | <?php echo esc_html( get_bloginfo( 'name' ) ); ?></title>
	<?php wp_head(); ?>
</head>

<body class="maintenance">
<?php if (defined('FW')) :
    //header phone number
	$header_phone = function_exists( 'fw_get_db_customizer_option' ) ? fw_get_db_customizer_option( 'header_phone' ) : '';
    ?>
    <header id="header" class="main-header-wrap">
        <div class="page_header ds toggler_xs_right affix-top">
            <div class="container-fluid">
                <div class="row">
                    <div class="col-sm-12 display_table">
                        <div class="header_left_logo display_table_cell">
							<?php get_template_part( 'template-parts/header/header-logo' ); ?>
                        </div>
						<?php if ( ( ! empty( $header_phone ) ) ) { ?>
                            <div class="header_right_buttons display_table_cell text-right hidden-xs">
	                            <?php if ( $header_phone ) : ?>
                                    <span class="header_phone">
									<?php echo wp_kses_post( $header_phone ); ?>
						        </span>
	                            <?php endif; //header_text ?>
                            </div><!-- eof .header_button -->
						<?php } ?>
                    </div><!--	eof .col-sm-* -->
                </div><!--	eof .row-->
            </div> <!--	eof .container-->
        </div><!-- eof .page_header -->
    </header>
    <section class="cs page_copyright section_padding_15">
        <h3 class="hidden"><?php echo esc_html__( 'Page Copyright', 'dotdigital' ); ?></h3>
        <div class="container-fluid">
            <div class="row">
                <div class="col-sm-12 text-center">
                    <p><?php echo wp_kses_post( function_exists( 'fw_get_db_customizer_option' ) ? fw_get_db_customizer_option( 'copyrights_text' ) : esc_html__( 'Powered by WordPress', 'dotdigital' ) ); ?></p>
                </div>
            </div>
        </div>
    </section><!-- .copyrights -->
<?php endif; ?>
</body>
</html>
